package gov.va.genisis2.swagger;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * SwaggerConfig is used to create a Docket bean and
 * its select() method returns an instance of ApiSelectorBuilder, 
 * which provides a way to control the endpoints exposed by Swagger.
 * 
 * Predicates for selection of RequestHandlers can be configured with 
 * the help of RequestHandlerSelectors and PathSelectors. Using any() for 
 * both will make documentation for your entire API available through Swagger.
 * 
 * @author Prasad Thummalapalli
 *
 */
@Configuration
@EnableSwagger2
@PropertySource({ "classpath:genisis-swagger.properties" })
public class SwaggerConfig {
	
	@Value("${genisis.api.title}")
	private String genisisApiTitle;

	@Value("${genisis.api.desc}")
	private String genisisApiDesc;
	
	@Value("${genisis.api.verion}")
	private String genisisApiVersion;
	
	@Value("${genisis.user.rest.tag.name}")
	private String userTagName;
	
	@Value("${genisis.user.rest.tag.desc}")
	private String userTagDesc;
	
	@Value("${genisis.requests.rest.tag.name}")
	private String requestsTagName;
	
	@Value("${genisis.requests.rest.tag.desc}")
	private String requestsTagDesc;
	
	@Value("${genisis.study.rest.tag.name}")
	private String studyTagName;
	
	@Value("${genisis.study.rest.tag.desc}")
	private String studyTagDesc;
	
	@Value("${genisis.comment.rest.tag.name}")
	private String commentTagName;
	
	@Value("${genisis.comment.rest.tag.desc}")
	private String commentTagDesc;
	
	@Value("${genisis.misc.rest.tag.name}")
	private String miscTagName;
	
	@Value("${genisis.misc.rest.tag.desc}")
	private String miscTagDesc;

	@Bean
	public Docket api() {
		Tag userTag = new Tag(userTagName, userTagDesc);
		Tag requestTag = new Tag(requestsTagName, requestsTagDesc);
		Tag studyApprovalTag = new Tag(studyTagName, studyTagDesc);
		Tag commentHistoryTag = new Tag(commentTagName, commentTagDesc);

		return new Docket(DocumentationType.SWAGGER_2)
				.select()
				.apis(RequestHandlerSelectors.any())
				.paths(PathSelectors.any()).build()
				.tags(userTag, new Tag[] { requestTag, studyApprovalTag, commentHistoryTag })
				.apiInfo(metadata());
	}

	private ApiInfo metadata() {
		return new ApiInfoBuilder()
				.title(genisisApiTitle)
				.description(genisisApiDesc)
				.version(genisisApiVersion)
				.build();
	}
	
	public void setUserTagName(String userTagName) {
		this.userTagName = userTagName;
	}
	
	public void setRequestsTagName(String requestsTagName) {
		this.requestsTagName = requestsTagName;
	}
	
	public void setStudyTagName(String studyTagName) {
		this.studyTagName = studyTagName;
	}
	
	public void setCommentTagName(String commentTagName) {
		this.commentTagName = commentTagName;
	}
}
